/*
 * Decompiled with CFR 0.152.
 */
package net.ftb.log;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import net.ftb.log.ILogListener;
import net.ftb.log.LogEntry;

public class LogThread
extends Thread {
    private BlockingQueue<LogEntry> logQueue = new LinkedBlockingQueue<LogEntry>();
    private List<ILogListener> listeners;

    public LogThread(List<ILogListener> listeners) {
        this.listeners = listeners;
        this.setDaemon(true);
    }

    @Override
    public void run() {
        this.setName("Log dispatcher");
        try {
            LogEntry entry;
            while ((entry = this.logQueue.take()) != null) {
                if (this.listeners.isEmpty()) continue;
                ArrayList<ILogListener> tempListeners = new ArrayList<ILogListener>();
                tempListeners.addAll(this.listeners);
                for (ILogListener listener : tempListeners) {
                    listener.onLogEvent(entry);
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void handleLog(LogEntry logEntry) {
        try {
            this.logQueue.put(logEntry);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

